using System;
/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor.intrusiondetection
{
    using System.Collections.Generic;
    using org.owasp.appsensor;

    /**
     * This interface represents the storage object for intrusions that 
     * occur in the application.  The implementation of this interface 
     * (DefaultIntrusionStore by default) is used to store the intrusions
     * that are seen by the AppSensorIntrusionDetector.  
     * <p>
     * Additionally, there are a few convenience methods that can be 
     * used in various ways, one of which might be for some type of 
     * reporting.
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since February 24, 2010
     */
    public interface IntrusionStore
    {

        /**
         * Add the current exception to the intrusion store
         * in the context of the current user.
         * @param e exception to store for the current user
         * @return the AppSensorIntrusion object created by this exception
         */
        AppSensorIntrusion addExceptionToIntrusionStore(Exception e);

        /**
         * Retrieve the IntrusionRecord for the current user.
         * @return the IntrusionRecord for the current user.
         */
        IntrusionRecord getIntrusionRecordForCurrentUser();

        /**
         * Retrieve the IntrusionRecord for the SYSTEM user.
         * This is the user utilized for exceptions that are not
         * relative to a specific user, ie. exceptions spawned
         * via an AppSensorSystemException
         * @return
         */
        IntrusionRecord getIntrusionRecordForSystemUser();

        /**
         * Retrieve the IntrusionRecord for the specified user.
         * @param user user whose IntrusionRecord is requested
         * @return the IntrusionRecord for the specified user.
         */
        IntrusionRecord getIntrusionRecordForUser(ASUser user);

        /**
         * Retrieve the full data store of IntrusionRecord's.  
         * This method is likely to be used for reporting.  In 
         * implementations with large applications, it may make 
         * sense to only return a subset of this data
         * @return full data store of IntrusionRecord's in the IntrusionStore
         */
        List<IntrusionRecord> getAllIntrusionRecords();
    }
}